/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpManager.IPAddress;
import ibm.nways.analysis.dpManager.SortableObject;
import java.io.Serializable;

public class RangeMarker
implements SortableObject,
Serializable {
    public static final int START = 1;
    public static final int END = 2;
    public static final int RANGE_START = 3;
    public static final int RANGE_END = 4;
    private long ipAddress;
    private String dpeName;
    private int type;

    public RangeMarker(int n, String string, String string2) {
        this.type = n;
        this.dpeName = string;
        this.ipAddress = IPAddress.toLong(string2);
    }

    public RangeMarker(int n, String string, long l) {
        this.type = n;
        this.dpeName = string;
        this.ipAddress = l;
    }

    public long sortKey() {
        return this.ipAddress;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        RangeMarker rangeMarker = (RangeMarker)object;
        return rangeMarker.getDPEAddress().equals(this.dpeName) && rangeMarker.getIpAddress() == this.ipAddress && rangeMarker.getType() == this.type;
    }

    public boolean greater(Object object) {
        RangeMarker rangeMarker = (RangeMarker)object;
        return rangeMarker.getDPEAddress().equals(this.dpeName) && rangeMarker.getIpAddress() == this.ipAddress && this.type > rangeMarker.getType();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getStringIpAddress()) + " : " + this.getDPEAddress() + " : ");
        if (this.type == 1) {
            stringBuffer.append(" START ");
        } else if (this.type == 2) {
            stringBuffer.append(" END ");
        } else if (this.type == 3) {
            stringBuffer.append(" RANGE START ");
        } else if (this.type == 4) {
            stringBuffer.append(" RANGE END ");
        }
        stringBuffer.append(" : " + this.ipAddress);
        return stringBuffer.toString();
    }

    public String getStringIpAddress() {
        return IPAddress.toString(this.ipAddress);
    }

    public long getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(long l) {
        this.ipAddress = l;
    }

    public String getDPEAddress() {
        return this.dpeName;
    }
}

